/*
 * @(#)ElementEvent.java  1.0  June 8, 2003
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.simulation;

import java.util.*;
/**
 * An event which indicates a change in a SimulatedObject object.
 * 
 * 
 * @author Werner Randelshofer, Staldenmattweg 2, CH-6405 Immensee, Switzerland.
 * @version 1.0  June 8, 2003  Created.
 */
public class SimulatedObjectEvent extends EventObject {
    private SimulatedRelationship relationship;
    
    /** Creates a new instance. */
    public SimulatedObjectEvent(SimulatedObject source) {
        this(source, null);
    }
    public SimulatedObjectEvent(SimulatedObject source, SimulatedRelationship relationship) {
        super(source);
        this.relationship = relationship;
    }
    
    /**
     * Get's the SimulatedObject that originated the event.
     */
    public SimulatedObject getObject() {
        return (SimulatedObject) getSource();
    }
    /**
     * Get's the SimulatedRelationship that caused the event.
     */
    public SimulatedRelationship getRelationship() {
        return relationship;
    }
    
}
